
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("Miles_Investment")

    # Create variables
    x = m.addVar(name="floral_investment")
    y = m.addVar(name="healthcare_investment")

    # Set objective function
    m.setObjective(1.3 * x + 1.5 * y, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x + y <= 10000, "total_investment")
    m.addConstr(x >= 0.25 * (x + y), "floral_min_percent")
    m.addConstr(y >= 2000, "healthcare_min_investment")

    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal investment strategy:")
        print(f"Floral Industry: ${x.x:.2f}")
        print(f"Healthcare Industry: ${y.x:.2f}")
        print(f"Total Profit: ${m.objVal:.2f}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")
