
from gurobipy import *

# Create a model
m = Model("Miles_Investment")

# Define the decision variables
x_f = m.addVar(name="floral_investment", lb=0)
x_h = m.addVar(name="healthcare_investment", lb=0)

# Define the objective function
m.setObjective(1.3*x_f + 1.5*x_h, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_f + x_h <= 10000, name="total_investment")
m.addConstr(x_f >= 0.25*(x_f + x_h), name="floral_percentage")
m.addConstr(x_h >= 2000, name="healthcare_minimum")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Floral Investment: {x_f.x}")
    print(f"Healthcare Investment: {x_h.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
