
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="floral_investment")
    y = model.addVar(lb=0, name="healthcare_investment")

    # Objective function: Maximize 1.3x + 1.5y
    model.setObjective(1.3 * x + 1.5 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 10000, name="total_investment")
    model.addConstr(y >= 2000, name="healthcare_min_investment")
    model.addConstr(3 * x >= y, name="floral_min_investment_ratio")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in floral industry: ${x.varValue}")
        print(f"Optimal investment in healthcare industry: ${y.varValue}")
        print(f"Maximal profit: ${model.objVal}")
    else:
        print("The problem is infeasible.")

solve_investment_problem()
