
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("figurine_production")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="superhero_figurines")
y = model.addVar(vtype=GRB.INTEGER, name="cartoon_figurines")

# Set objective function
model.setObjective(10*x + 8*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 3*y <= 1000, "printer_A_constraint")
model.addConstr(4*x + 7*y <= 1000, "printer_B_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of superhero figurines: {x.x}")
    print(f"Number of cartoon figurines: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

