
from gurobipy import *

# Create a model
m = Model("Jake_Figurines")

# Define variables
superhero_figurines = m.addVar(vtype=GRB.CONTINUOUS, name="superhero_figurines", lb=0)
cartoon_figurines = m.addVar(vtype=GRB.CONTINUOUS, name="cartoon_figurines", lb=0)

# Objective function: Maximize profit
m.setObjective(10*superhero_figurines + 8*cartoon_figurines, GRB.MAXIMIZE)

# Constraints
m.addConstr(5*superhero_figurines + 3*cartoon_figurines <= 1000, name="Printer_A_Time")
m.addConstr(4*superhero_figurines + 7*cartoon_figurines <= 1000, name="Printer_B_Time")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal number of superhero figurines: {superhero_figurines.x:.2f}")
    print(f"Optimal number of cartoon figurines: {cartoon_figurines.x:.2f}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
