
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="superhero_figurines")
    y = model.addVar(lb=0, name="cartoon_figurines")

    # Define the objective function
    model.setObjective(10 * x + 8 * y, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(5 * x + 3 * y <= 1000, name="printer_A_constraint")
    model.addConstr(4 * x + 7 * y <= 1000, name="printer_B_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum profit: ${10 * x.varValue + 8 * y.varValue:.2f}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
