
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Cooper's Produce Optimization")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes") # Number of potatoes
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pumpkins") # Number of pumpkins

# Set objective function
m.setObjective(1.5*x + 2.8*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.5*x + 0.9*y <= 1000, "budget")
m.addConstr(y <= (1/3)*x, "pumpkin_ratio")
m.addConstr(x >= 250, "min_potatoes")
m.addConstr(x <= 800, "max_potatoes")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal:.2f}")
    print(f"Number of Potatoes to Sell: {x.x:.0f}")
    print(f"Number of Pumpkins to Sell: {y.x:.0f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

