
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=250, ub=800, name="potatoes")  # At least 250, at most 800 potatoes
    y = model.addVar(lb=0, name="pumpkins")  # Non-negative number of pumpkins

    # Objective function: Maximize profit
    model.setObjective(1.5 * x + 2.8 * y, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(0.50 * x + 0.90 * y <= 1000, name="budget_constraint")

    # Pumpkin to potato ratio constraint
    model.addConstr(y <= (1/3) * x, name="pumpkin_to_potato_ratio")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of potatoes: {x.varValue}")
        print(f"Optimal number of pumpkins: {y.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
