
import gurobipy as gp

# Create a new model
model = gp.Model("CroissantProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chocolate_croissants")
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="strawberry_croissants")

# Set objective function
model.setObjective(4*x + 6*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 1200, "sales_limit")
model.addConstr(3*x + 5*y <= 6000, "budget_limit")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Chocolate Croissants: {x.x}")
    print(f"Strawberry Croissants: {y.x}")
    print(f"Total Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

