
from gurobipy import *

# Create a new model
m = Model("Tim_Bakery_Profit")

# Define the decision variables
x = m.addVar(lb=0, name="chocolate_croissants")
y = m.addVar(lb=0, name="strawberry_croissants")

# Set the objective function to maximize profit
m.setObjective(4*x + 6*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 1200, "total_croissants")
m.addConstr(3*x + 5*y <= 6000, "budget")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chocolate Croissants: {x.x}")
    print(f"Strawberry Croissants: {y.x}")
    print(f"Total Profit: ${4*x.x + 6*y.x}")
else:
    print("No optimal solution found")

