
import gurobi

def solve_croissant_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define decision variables
    x = model.addVar(name="chocolate_croissants", lb=0, ub=None, obj=4)
    y = model.addVar(name="strawberry_croissants", lb=0, ub=None, obj=6)

    # Add constraints
    model.addConstr(x + y <= 1200, name="croissant_sales_limit")
    model.addConstr(3*x + 5*y <= 6000, name="expenditure_limit")

    # Set the model objective to maximize
    model.setObjective(x.obj + y.obj, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Chocolate Croissants: {x.x}")
        print(f"Strawberry Croissants: {y.x}")
        print(f"Total Profit: {model.objVal}")
    else:
        print("The model is infeasible or unbounded.")

solve_croissant_problem()
