
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Ticket_Optimization")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="guided_tours") # Integer since you can't sell fractions of tours
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_tickets")

# Set objective function
m.setObjective(500*x + 200*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 300, "total_tickets")
m.addConstr(x >= 50, "min_guided_tours")
m.addConstr(y >= 2*x, "regular_preference")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of guided tours: {x.x}")
    print(f"Number of regular tickets: {y.x}")
    print(f"Optimal Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {m.status}")

