
from gurobipy import *

# Create a new model
m = Model("Travel_Company_Optimization")

# Define decision variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="guided_tour_packages")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="regular_tickets")

# Set the objective function to maximize profit
m.setObjective(500*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 300, "total_tickets_constraint")
m.addConstr(x1 >= 50, "guided_tour_reservation_constraint")
m.addConstr(x2 >= 2*x1, "regular_tickets_preference_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Guided tour packages to sell: {x1.x}")
    print(f"Regular tickets to sell: {x2.x}")
    print(f"Maximum profit: ${500*x1.x + 200*x2.x:.2f}")
else:
    print("No optimal solution found. The problem might be infeasible.")
