
import gurobipy as gp

# Create a new model
m = gp.Model("Travel_Company_Optimization")

# Decision variables
G = m.addVar(lb=50, name="Guided_Tour_Packages")  # At least 50 guided tour packages
R = m.addVar(name="Regular_Tickets")

# Objective function: Maximize profit
m.setObjective(500*G + 200*R, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(G + R <= 300, name="Total_Tickets")  # At most 300 tickets
m.addConstr(R >= 2*G, name="Regular_vs_Guided")  # At least 2 times regular tickets

# Solve the model
m.solve()

# Output solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Guided Tour Packages = {G.varValue}, Regular Tickets = {R.varValue}")
    print(f"Max Profit: ${500*G.varValue + 200*R.varValue}")
else:
    print("No optimal solution found.")
