
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("tea_shop_optimization")

# Create decision variables
x = model.addVar(vtype=GRB.CONTINUOUS, name="x") # Package X
y = model.addVar(vtype=GRB.CONTINUOUS, name="y") # Package Y


# Set objective function
model.setObjective(70*x + 120*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 3*y <= 1200, "green_tea_constraint")
model.addConstr(2*x + 4*y <= 900, "black_tea_constraint")
model.addConstr(x >= 0, "x_non_negativity")
model.addConstr(y >= 0, "y_non_negativity")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Number of package X: {x.x:.2f}")
    print(f"Number of package Y: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

