
from gurobipy import *

# Create a new model
model = Model("Tea_Shop_Optimization")

# Define variables
x = model.addVar(vtype=GRB.CONTINUOUS, name="package_x")
y = model.addVar(vtype=GRB.CONTINUOUS, name="package_y")

# Objective function: Maximize profit
model.setObjective(70*x + 120*y, GRB.MAXIMIZE)

# Constraints
model.addConstr(5*x + 3*y <= 1200, "green_tea_constraint")
model.addConstr(2*x + 4*y <= 900, "black_tea_constraint")

# Optimize the model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Package X: {x.x}")
    print(f"Package Y: {y.x}")
    print(f"Total Profit: ${70*x.x + 120*y.x:.2f}")
else:
    print("No optimal solution found")
