
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
x = m.addVar(lb=0, name="x")  # number of packages X
y = m.addVar(lb=0, name="y")  # number of packages Y

# Define the objective function
m.setObjective(70*x + 120*y, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(5*x + 3*y <= 1200, name="green_tea")
m.addConstr(2*x + 4*y <= 900, name="black_tea")

# Optimize the model
m.optimize()

# Print the results
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Packages X: {x.varValue}")
    print(f"Packages Y: {y.varValue}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
