
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("VehicleProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="SUVs")
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="Minivans")

# Set objective function
model.setObjective(7500*x + 4000*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x <= 5, "SUV_Capacity")
model.addConstr(y <= 3, "Minivan_Capacity")
model.addConstr(x + y <= 5, "Finishing_Capacity")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of SUVs to produce: {x.x}")
    print(f"Number of Minivans to produce: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

