
from gurobipy import *

# Create a model
m = Model("Vehicle_Production")

# Define decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="SUV_Cars")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="Minivans")

# Set the objective function
m.setObjective(7500*x + 4000*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x <= 5, "SUV_Factory_Capacity")
m.addConstr(y <= 3, "Minivan_Factory_Capacity")
m.addConstr(x + y <= 5, "Third_Party_Processing_Capacity")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Produce {x.x} SUV cars and {y.x} minivans.")
else:
    print("No optimal solution found. The problem might be infeasible.")

print(f"Objective function value (Max Profit): ${m.objVal}")
