
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
suv = model.addVar(lb=0, ub=5, name="suv", vtype=gurobi.GRB.CONTINUOUS)
minivan = model.addVar(lb=0, ub=3, name="minivan", vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(7500 * suv + 4000 * minivan, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(suv <= 5, name="suv_constraint")
model.addConstr(minivan <= 3, name="minivan_constraint")
model.addConstr(suv + minivan <= 5, name="finishing_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"SUV cars: {suv.x:.2f}")
    print(f"Minivans: {minivan.x:.2f}")
    print(f"Max Profit: {model.objVal:.2f}")
else:
    print("No optimal solution found.")
