
import gurobipy as gp

# Create a new model
m = gp.Model("snow_removal")

# Create variables
x = m.addVar(lb=0, name="northern_city_snow")  # Snow removed from northern city (kg)
y = m.addVar(lb=0, name="southern_city_snow")  # Snow removed from southern city (kg)

# Set objective function
m.setObjective(2*x + 1.5*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + y <= 500, "snow_plow_time")
m.addConstr(x + 3*y <= 500, "truck_time")
m.addConstr(5*x + 2*y <= 500, "shovel_time")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal snow removal:")
    print(f"  Northern City: {x.x:.2f} kg")
    print(f"  Southern City: {y.x:.2f} kg")
    print(f"  Total Profit: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

