
from gurobipy import *

# Create a new model
m = Model("Snow Removal Optimization")

# Define variables
x_n = m.addVar(lb=0, name="northern_city")  # Kilograms of snow removed from the northern city
x_s = m.addVar(lb=0, name="southern_city")  # Kilograms of snow removed from the southern city

# Set objective function: Maximize profit
m.setObjective(2*x_n + 1.5*x_s, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x_n + x_s <= 500, name="snow_plow_time")
m.addConstr(x_n + 3*x_s <= 500, name="truck_time")
m.addConstr(5*x_n + 2*x_s <= 500, name="shovel_time")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Remove {x_n.x} kilograms from the northern city and {x_s.x} kilograms from the southern city.")
else:
    print("No optimal solution found")
