
import gurobipy as gp

# Create a new model
model = gp.Model("Snow_Removal")

# Variables
x_n = model.addVar(name="x_n", lb=0, ub=gp.GRB.INFINITY)  # kilograms of snow in the northern city
x_s = model.addVar(name="x_s", lb=0, ub=gp.GRB.INFINITY)  # kilograms of snow in the southern city

# Objective function
model.setObjective(2 * x_n + 1.5 * x_s, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(2 * x_n + x_s <= 500, name="snow_plow_constraint")
model.addConstr(x_n + 3 * x_s <= 500, name="truck_constraint")
model.addConstr(5 * x_n + 2 * x_s <= 500, name="shovel_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x_n = {x_n.varValue}, x_s = {x_s.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("The model is infeasible")
