
import gurobipy as gp

# Create a new model
m = gp.Model("diet_problem")

# Create variables
x = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="beans")
y = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cereal")

# Set objective function
m.setObjective(2*x + y, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(50*x + 30*y >= 300, "carbohydrate_req")
m.addConstr(20*x + 5*y >= 150, "protein_req")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of bean servings: {x.x}")
    print(f"Number of cereal servings: {y.x}")
    print(f"Minimum cost: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

