
from gurobipy import *

# Create a new model
m = Model("diet_problem")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="beans")
y = m.addVar(vtype=GRB.INTEGER, name="cereal")

# Set the objective function
m.setObjective(2*x + y, GRB.MINIMIZE)

# Add constraints
m.addConstr(50*x + 30*y >= 300, "carbohydrates")
m.addConstr(20*x + 5*y >= 150, "protein")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Beans: {x.x}")
    print(f"Cereal: {y.x}")
    print(f"Total Cost: ${2*x.x + y.x}")
else:
    print("No optimal solution found")
