
import gurobi as gp

# Create a new model
model = gp.Model("diet_problem")

# Define the decision variables
x = model.addVar(name="beans", lb=0)  # servings of beans
y = model.addVar(name="cereal", lb=0)  # servings of cereal

# Objective: minimize cost
model.setObjective(2*x + y, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(50*x + 30*y >= 300, name="carbohydrates")
model.addConstr(20*x + 5*y >= 150, name="protein")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Minimum cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
