
from gurobipy import *

# Create a model
m = Model("Ad_Optimization")

# Define decision variables
x1 = m.addVar(name='taxi_ads', vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name='bus_ads', vtype=GRB.INTEGER, lb=0)
x3 = m.addVar(name='private_car_ads', vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(5000*x1 + 12000*x2 + 2000*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(500*x1 + 1000*x2 + 300*x3 <= 20000, name='budget')
m.addConstr(x2 <= 8, name='bus_limit')
m.addConstr(x1 <= 0.3*(x1 + x2 + x3), name='taxi_percentage')
m.addConstr(x3 >= 0.2*(x1 + x2 + x3), name='private_car_percentage')

# Optimize the model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
