
import gurobipy as gp

# Create a new model
m = gp.Model("Ad_Placement")

# Decision variables
x_t = m.addVar(name="taxis", vtype=gp.GRB.INTEGER)  # Ads on taxis
x_b = m.addVar(name="buses", vtype=gp.GRB.INTEGER)  # Ads on buses
x_c = m.addVar(name="cars", vtype=gp.GRB.INTEGER)  # Ads on privately owned cars

# Objective: Maximize viewership
m.setObjective(5000*x_t + 12000*x_b + 2000*x_c, gp.GRB.MAXIMIZE)

# Budget constraint
m.addConstr(500*x_t + 1000*x_b + 300*x_c <= 20000, name="budget")

# Bus ads limit
m.addConstr(x_b <= 8, name="bus_limit")

# Taxi ads percentage limit
m.addConstr(x_t <= 0.3*(x_t + x_b + x_c), name="taxi_percentage")

# Privately owned car ads percentage limit
m.addConstr(x_c >= 0.2*(x_t + x_b + x_c), name="car_percentage")

# Non-negativity
m.addConstr(x_t >= 0, name="taxis_nonneg")
m.addConstr(x_b >= 0, name="buses_nonneg")
m.addConstr(x_c >= 0, name="cars_nonneg")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Taxis: {x_t.varValue}")
    print(f"Buses: {x_b.varValue}")
    print(f"Cars: {x_c.varValue}")
    print(f"Max Viewership: {m.objVal}")
else:
    print("No optimal solution found.")
