
import gurobipy as gp

# Create a new model
model = gp.Model("IceCreamProduction")

# Create decision variables
x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # Regular ice cream
x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # Premium ice cream

# Set objective function
model.setObjective(1*x1 + 2.5*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 40, "Demand_Regular")
model.addConstr(x2 <= 25, "Demand_Premium")
model.addConstr(x1 + x2 <= 60, "Total_Production")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of regular ice creams (x1): {x1.x}")
    print(f"Number of premium ice creams (x2): {x2.x}")
    print(f"Maximum Profit: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

