
from gurobipy import *

# Create a new model
model = Model("Ice Cream Production")

# Define the decision variables
x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Regular_Ice_Cream")
x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Premium_Ice_Cream")

# Set the objective function to maximize profit
model.setObjective(1*x1 + 2.50*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 40, "Regular_Demand")
model.addConstr(x2 <= 25, "Premium_Demand")
model.addConstr(x1 + x2 <= 60, "Total_Production")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("The model is infeasible")
