
import gurobi

def solve_ice_cream_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="regular_ice_cream")  # Number of regular ice creams
    x2 = model.addVar(lb=0, name="premium_ice_cream")  # Number of premium ice creams

    # Objective function: Maximize profit
    model.setObjective(1*x1 + 2.5*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 <= 40, name="regular_demand_constraint")
    model.addConstr(x2 <= 25, name="premium_demand_constraint")
    model.addConstr(x1 + x2 <= 60, name="total_production_constraint")

    # Optimize the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: ${1*x1.varValue + 2.5*x2.varValue:.2f}")
    else:
        print("No optimal solution found.")

# Run the function
solve_ice_cream_problem()
