
import gurobipy as gp

# Create a new model
m = gp.Model("BakeryOptimization")

# Create variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="donuts") # Number of donut batches
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cookies") # Number of cookie batches

# Set objective function
m.setObjective(20*x + 15*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 5*y <= 200, "Jake_Time")
m.addConstr(10*x + 25*y <= 300, "Jill_Time")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of donut batches (x): {x.x}")
    print(f"Number of cookie batches (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

