
from gurobipy import *

# Create a model
m = Model("Bakery_Optimization")

# Define decision variables
donuts = m.addVar(vtype=GRB.INTEGER, name="donuts")
cookies = m.addVar(vtype=GRB.INTEGER, name="cookies")

# Objective function: Maximize profit
m.setObjective(20*donuts + 15*cookies, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*donuts + 5*cookies <= 200, "Jake_Time")
m.addConstr(10*donuts + 25*cookies <= 300, "Jill_Time")

# Non-negativity constraints (assuming you can't produce negative batches)
m.addConstr(donuts >= 0, "Non_Neg_Donuts")
m.addConstr(cookies >= 0, "Non_Neg_Cookies")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Donuts to produce: {donuts.x}")
    print(f"Cookies to produce: {cookies.x}")
    print(f"Maximum Profit: ${20*donuts.x + 15*cookies.x}")
else:
    print("No optimal solution found. The model may be infeasible.")
