
import gurobi as gp

# Create a new model
model = gp.Model("Donuts_and_Cookies")

# Define the variables
D = model.addVar(name="Donuts", lb=0, vtype=gp.GRB.CONTINUOUS)
C = model.addVar(name="Cookies", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(20 * D + 15 * C, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * D + 5 * C <= 200, name="Jake_Time")
model.addConstr(10 * D + 25 * C <= 300, name="Jill_Time")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal batches of donuts: {D.varValue}")
    print(f"Optimal batches of cookies: {C.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
