
import gurobipy as gp

# Create a new model
model = gp.Model("CoffeeBlend")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="Drummondville")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="Victoriaville")

# Set objective function
model.setObjective(5*x + 7*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(600*x + 375*y <= 24000, "Arabica")
model.addConstr(400*x + 625*y <= 17000, "Robusta")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Drummondville Bags: {x.x}")
    print(f"Victoriaville Bags: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

