
from gurobipy import *

# Create a new model
m = Model("Coffee_Blend_Optimization")

# Decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Drummondville_Bags")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Victoriaville_Bags")

# Objective function: Maximize profit
m.setObjective(5*x + 7*y, GRB.MAXIMIZE)

# Constraint 1: Arabica beans limit
m.addConstr(600*x + 375*y <= 24000, "Arabica_Limit")

# Constraint 2: Robusta beans limit
m.addConstr(400*x + 625*y <= 17000, "Robusta_Limit")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Drummondville bags: {x.x}")
    print(f"Victoriaville bags: {y.x}")
    print(f"Maximum profit: ${5*x.x + 7*y.x:.2f}")
else:
    print("No optimal solution found.")
