
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(name="Drummondville", lb=0, ub=gurobi.GRB.INFINITY)
y = model.addVar(name="Victoriaville", lb=0, ub=gurobi.GRB.INFINITY)

# Define the objective function
model.setObjective(5 * x + 7 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(600 * x + 375 * y <= 24000, name="Arabica_Constraint")
model.addConstr(400 * x + 625 * y <= 17000, name="Robusta_Constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Drummondville blend: {x.varValue} bags")
    print(f"Victoriaville blend: {y.varValue} bags")
    print(f"Max profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
