
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Farm_Optimization")

# Create decision variables
x = m.addVar(lb=0, name="beans_acres")  # Acres of beans
y = m.addVar(lb=0, name="peas_acres")  # Acres of peas


# Set objective function
m.setObjective(200*x + 250*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "land_constraint")
m.addConstr(12*x + 15*y <= 1350, "bug_repellant_constraint")


# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of beans")
    print(f"Plant {y.x:.2f} acres of peas")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

