
from gurobipy import *

# Create a new model
m = Model("Gardener_Optimization")

# Define the decision variables
B = m.addVar(name='beans', vtype=GRB.CONTINUOUS, lb=0)
P = m.addVar(name='peas', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(200*B + 250*P, GRB.MAXIMIZE)

# Add constraints
m.addConstr(B + P <= 100, name='total_acreage')
m.addConstr(12*B + 15*P <= 1350, name='bug_repellant')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Acres of beans: {B.x}, Acres of peas: {P.x}")
    print(f"Maximum profit: ${200*B.x + 250*P.x:.2f}")
else:
    print("No optimal solution found")
