
import gurobi

def solve_gardening_problem():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    B = model.addVar(lb=0, name="Beans_Acres")
    P = model.addVar(lb=0, name="Peas_Acres")

    # Objective function: Maximize profit
    model.setObjective(200*B + 250*P, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(B + P <= 100, name="Land_Constraint")
    model.addConstr(12*B + 15*P <= 1350, name="Bug_Repellant_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of beans: {B.varValue}")
        print(f"Optimal acres of peas: {P.varValue}")
        print(f"Max Profit: ${200*B.varValue + 250*P.varValue}")
    else:
        print("The problem is infeasible")

solve_gardening_problem()
