
import gurobipy as gp

# Create a new model
m = gp.Model("Investment_Optimization")

# Create decision variables
x = m.addVar(nonnegative=True, name="textile_investment")
y = m.addVar(nonnegative=True, name="telecom_investment")

# Set objective function
m.setObjective(0.06 * x + 0.08 * y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 500000, "total_investment")
m.addConstr(x >= 150000, "min_textile")
m.addConstr(y <= 250000, "max_telecom")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in Textiles: ${x.x:.2f}")
    print(f"Optimal investment in Telecom: ${y.x:.2f}")
    print(f"Maximum return: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

