
from gurobipy import *

# Create a model
m = Model("Investment_Optimization")

# Define decision variables
x = m.addVar(lb=150000, name="textile_investment")
y = m.addVar(ub=250000, name="telecom_investment")

# Set the objective function
m.setObjective(0.06*x + 0.08*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y == 500000, "total_investment")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Textile Investment: ${x.x:.2f}")
    print(f"Telecom Investment: ${y.x:.2f}")
    print(f"Total Return: ${0.06*x.x + 0.08*y.x:.2f}")
else:
    print("No optimal solution found")
