
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="Textile_Investment")
    y = model.addVar(lb=0, name="Telecom_Investment")

    # Objective function: Maximize 0.06x + 0.08y
    model.setObjective(x * 0.06 + y * 0.08, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 500000, name="Total_Investment")
    model.addConstr(x >= 0.3 * 500000, name="Min_Textile_Investment")
    model.addConstr(y <= 0.5 * 500000, name="Max_Telecom_Investment")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in textile industry: ${x.varValue}")
        print(f"Optimal investment in telecom industry: ${y.varValue}")
        print(f"Max return: ${model.objVal}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
