
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Peanut_Transportation")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="train_trips")  # Integer since trips can't be fractional.
y = m.addVar(vtype=GRB.INTEGER, name="truck_trips")

# Set objective function
m.setObjective(80*x + 50*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x + 40*y <= 3000, "budget_constraint")
m.addConstr(x <= y, "train_trip_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of train trips (x): {x.x}")
    print(f"Number of truck trips (y): {y.x}")
    print(f"Total packages transported: {80*x.x + 50*y.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {m.status}")

