
from gurobipy import *

# Create a model
m = Model("Peanut_Transportation")

# Define the decision variables
x_train = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Train_Trips")
x_truck = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Truck_Trips")

# Set the objective function: Maximize the total number of packages transported
m.setObjective(80*x_train + 50*x_truck, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x_train + 40*x_truck <= 3000, "Total_Cost_Constraint")
m.addConstr(x_train <= x_truck, "Train_vs_Truck_Trips")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Maximum number of packages that can be transported: {m.objVal}")
    print(f"Number of train trips: {x_train.x}")
    print(f"Number of truck trips: {x_truck.x}")
else:
    print("Model is infeasible or unbounded.")
