
import gurobi

def solve_transportation_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    T = model.addVar(name="T", vtype=gurobi.GRB.INTEGER, lb=0)  # Train trips
    K = model.addVar(name="K", vtype=gurobi.GRB.INTEGER, lb=0)  # Truck trips

    # Objective: Maximize the number of packages transported
    model.setObjective(80 * T + 50 * K, gurobi.GRB.MAXIMIZE)

    # Cost constraint: 50T + 40K <= 3000
    model.addConstr(50 * T + 40 * K <= 3000, name="cost_constraint")

    # Trip constraint: T <= K
    model.addConstr(T <= K, name="trip_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Train trips = {T.varValue}, Truck trips = {K.varValue}")
        print(f"Maximum packages transported: {80 * T.varValue + 50 * K.varValue}")
    else:
        print("No optimal solution found")

solve_transportation_problem()
