
import gurobipy as gp

# Create a new model
model = gp.Model("soda_optimization")

# Create decision variables
x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # Soda 1
x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # Soda 2

# Set objective function
model.setObjective(5*x1 + 7*x2, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(3*x1 + 2*x2 >= 50, "caffeine_constraint")
model.addConstr(2*x1 + 5*x2 >= 40, "sugar_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Soda 1 cans: {x1.x}")
    print(f"Number of Soda 2 cans: {x2.x}")
    print(f"Minimum Cost: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

