
from gurobipy import *

# Create a new model
m = Model("Soda_Optimization")

# Define the decision variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Soda_1", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Soda_2", lb=0)

# Set the objective function: Minimize total cost
m.setObjective(5*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 >= 50, "Caffeine_Constraint")
m.addConstr(2*x1 + 5*x2 >= 40, "Sugar_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {x1.x} cans of Soda 1")
    print(f"Buy {x2.x} cans of Soda 2")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found")
