
import gurobi

def solve_soda_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Soda1", vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name="Soda2", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function: Minimize cost
    model.setObjective(5 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x1 + 2 * x2 >= 50, name="Caffeine_Requirement")
    model.addConstr(2 * x1 + 5 * x2 >= 40, name="Sugar_Requirement")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Soda 1 = {x1.varValue}, Soda 2 = {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible")
    else:
        print("The model has a non-optimal status")

solve_soda_problem()
