
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Fishing Optimization")

# Create variables
P = m.addVar(lb=0, name="Pacific_Days")
A = m.addVar(lb=0, name="Atlantic_Days")

# Set objective function
m.setObjective(5000*P + 7000*A, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*P + 4*A >= 18, "Fish_Constraint")
m.addConstr(2*P + 3*A >= 10, "Crab_Constraint")
m.addConstr(0.5*P + A >= 5, "Lobster_Constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Pacific Days: {P.x}")
    print(f"Atlantic Days: {A.x}")
    print(f"Total Cost: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {m.status}")

